import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, create_dataframe, df_copy, concatenate_objects, bind_dataframe, aggregate_grouped_data, positive_infinity, make_bins, join_dataframes, create_figure, create_barplot, set_plot_title, set_yaxis_label, show_plots, join_dataframes, anova_test, dropna

atp_tennis = read_csv_file('atp_tennis.csv')

# Define ranking groups based on average rank
bins = [0, 50, 200, positive_infinity()]
labels = ['Top-ranked', 'Mid-ranked', 'Low-ranked']
unique_player_data['Rank_Group'] = make_bins(unique_player_data['Avg_Rank'], bins=bins, labels=labels)

# Calculate the average win/loss ratio for each ranking group and surface type
grouped_data = join_dataframes(player_data, unique_player_data[['Player', 'Rank_Group']], on='Player')
grouped_data = bind_dataframe(grouped_data, ['Rank_Group', 'Surface'])
agg_dict = {'Win_Loss_Ratio': 'mean'}
grouped_data = aggregate_grouped_data(grouped_data, agg_dict)

print(grouped_data)
pickle.dump(grouped_data,open("./ref_result/grouped_data.pkl","wb"))